/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/

/*
 * Created on Feb 23, 2006
 */
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportDivision extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 238467387273745915L;

	public static final Code ENR = new Code("1");
	public static final Code IVM = new Code("2");
	public static final Code ENR_AND_IVM = new Code("3");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -5699456629035294442L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	public ReportDivision() {
		super();
	}
}
