/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 23, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class ReportDetailFor extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3965005202350905520L;	                                            

	public static final Code PROCESSED = new Code("1");
	public static final Code NOT_PROCESSED = new Code("2");
	public static final Code PROCESSED_AND_NOT_PROCESSED = new Code("3");
	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 7703918353565623324L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
    
    public ReportDetailFor() {
    	super();
    }
}

