/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Radiation Exposure Method.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class RadiationExposureMethod extends AbstractNamedActiveLookup
{
    
    private static final long serialVersionUID = -2172438893712373151L;

    // NEW SDS CODES
    public static final Code CODE_NAGASAKI_HIROSHIMA = new Code("2");

    public static final Code CODE_ATMOSPHERIC_NUCLEAR_TESTING = new Code("3");
    
    public static final Code CODE_HN_ATMOSPHERIC_TESTING = new Code("4");
    
    public static final Code CODE_UNDERGROUND_NUCLEAR_TESTING = new Code("5");
    
    public static final Code CODE_EXPOSURE_AT_NUCLEAR_FACILITY = new Code("6");
    
    public static final Code CODE_OTHER = new Code("7");
        

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 2979476480884977097L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public RadiationExposureMethod()
    {
        super();
    }
}