package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.common.model.lookup.RadiationExposureMethod.Code;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

//Java Classes

//Library Classes

//Framework Classes

/**
 * @author Commons Team
 * 
 */
public class RaceType
    extends AbstractNamedLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -4476661519033523470L;
   
    public static final Code CODE_AMERICAN_INDIAN_ALASKA= new Code("1002-5");
    public static final Code CODE_ASIAN = new Code("2028-9");
    public static final Code CODE_BLACK_AFRICAN = new Code("2054-5");
    public static final Code CODE_HAWAIIAN_PACIFIC = new Code("2076-8");
    public static final Code CODE_WHITE = new Code("2106-3");
    public static final Code CODE_UNKNOWN = new Code("UNK");
    public static final Code CODE_DECLINE_ANSWER = new Code("0000-0");

    /**
     * Default constructor.
     */
    public RaceType()
    {
        super();
    }
    
    public static class Code extends AbstractCode {
        /**
         * 
         */
        private static final long serialVersionUID = -5034620997785074066L;

        /**
         * An instance of serialVersionUID
         */
        
        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }   
}