/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * Pseudo SSN reason type lookup.
 * 
 * @author DNS   MANSOG
 * @date Jun 13, 2005 4:23:17 PM
 */
public class PseudoSSNReason 
		extends AbstractNamedActiveLookup {

    private static final long serialVersionUID = -6828270376077043270L;
    public static final Code CODE_NO_SSN_ASSIGNED= new Code("N");
    public static final Code CODE_REFUSED_TO_PROVIDE = new Code("R");
    public static final Code CODE_FOLLOWUP_REQD  = new Code("S");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -8679734997563905526L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
    
    /**
     * Default Constructor
     */
    public PseudoSSNReason() {
        super();
    }
}
