/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Procedure.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class Procedure extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 7917395117898016695L;
    /* Toe Amputation */
    public static final Code CODE_TOE_AMPUTATION = new Code("28810");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 3987252526705073768L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }


    /**
     * Default constructor.
     */
    public Procedure()
    {
        super();
    }
    
	private String codesettype;
	   
	   public String getCodesettype() {
	       return codesettype;
	   }
	   
	   public void setCodesettype(String codesetType) {
	       this.codesettype = codesetType;
	   }
}
