package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Phone Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PhoneType extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 5236826191373372531L;

    /** Home Code */
    public static final Code CODE_HOME = new Code("1");

    /** Business Code */
    public static final Code CODE_BUSINESS = new Code("2");

    /** Fax Code */
    public static final Code CODE_FAX = new Code("3");

    /** Mobile Code */
    public static final Code CODE_MOBILE = new Code("4");

    /** Pager Code */
    public static final Code CODE_PAGER = new Code("5");

    /** Insurance Carrier Phone Code */
    public static final Code CODE_INSURANCE_CARRIER_PHONE = new Code("6");

    /** Pre-Certification Phone Code */
    public static final Code CODE_PRE_CERTIFICATION_PHONE = new Code("7");

	/** Temporary Code */
    public static final Code CODE_TEMPORARY = new Code("13");

    /** Confidential Phone Code */
    public static final Code CODE_CONFIDENTIAL = new Code("14");
   

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 6340671995079424174L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public PhoneType()
    {
        super();
    }
}
