/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Phone Source of Change.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PhoneSourceOfChange extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 4549352698706018295L;

    /* VAMC Code */
    public static final Code CODE_VAMC = new Code("01");

    /* HEC Code */
    public static final Code CODE_HEC = new Code("02");
    public static final Code CODE_HBSC = new Code("03");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -8751916533844580871L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public PhoneSourceOfChange()
    {
        super();
    }
}

