package gov.va.med.esr.common.model.lookup;

//Java classes

//Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

//ESR classes

public class PersonMergeStatus extends AbstractNamedActiveLookup {

	private static final long serialVersionUID = -930926104740173937L;
	
	public static final Code IN_PROCESS = new Code("1");

	public static final Code NOT_STATRTED = new Code("2");

	public static final Code COMPLETED = new Code("3");

	public static class Code extends AbstractCode {

        private static final long serialVersionUID = -6852121223703591884L;
        
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public PersonMergeStatus() {
		super();
	}
}
