/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is permanent indicator used by the catastrophic disability condition.
 *
 * @author DNS   SURVES
 */
public class PermanentIndicator extends AbstractNamedActiveLookup {
 
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6732001045801048775L;

	/* Permanent */
    public static final Code PERMANENT = new Code("1");

	/* NotPermanent */
    public static final Code NOT_PERMANENT = new Code("2");
    
	/* Unknown */
    public static final Code UNKNOWN = new Code("3");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 5540718038072430394L;

		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
    /**
     * Default constructor.
     */
    public PermanentIndicator()
    {
        super();
    }
    
    /**
     * Return true for 1|y false for 0/n and null for unknown/2
     * @return
     */
    public Boolean toBoolean() {
    	if (PERMANENT.getCode().equals(this.getCode())){
    		return Boolean.TRUE;    		
    	}else if (NOT_PERMANENT.getCode().equals(this.getCode())){
    		return Boolean.FALSE;
    	}else {
    		return null;
    	}
    }

}