/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.model.lookup.AbstractCode;

/**
 * Lookup class for Com Letter Type.
 * <p/>
 * Project: Common
 *
 * @author Ghazenfer Mansoor
 * @version 1.0
 */
public class PensionReasonCode extends AbstractNamedActiveLookup
{
	
	private static final long serialVersionUID = 7372220649868169229L;

    public static class Code extends AbstractCode
    {
        /**
		 * 
		 */
		private static final long serialVersionUID = -4787122020471736970L;

		/**
         * An instance of serialVersionUID
         */

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
    /**
     * Default constructor.
     */
    public PensionReasonCode()
    {
        super();
    }

}