package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * POW Data Source.
 * @author Yi He
 * @author Andrew Pach
 * @version 3.0
 */
public class POWDataSource extends AbstractNamedActiveLookup
{

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = -7518165101537869603L;

    // Define public static final Codes here when the POW_DATA_SOURCE_TYPE table is finalized.
    public static final Code CODE_VAMC = new Code("5");
    public static final Code CODE_MVR_VBA = new Code("4");

    public static class Code extends AbstractCode
    {
 
        /**
         * An instance of serialVersionUID
         */
        private static final long serialVersionUID = -7680501685742165648L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
   	public POWDataSource() {
		super();
	}
	
}
