package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.StringUtils;

// ESR Classes

/**
 * @author Andrew Pach
 * @author Yi He
 * @version 3.0
 */
public class POWCampLocation extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 4415620633145262156L;

    // Define public static final Codes here when the STD_POWCASUALTYLOCATION table is finalized.
    public static final Code CODE_STALAG1A = new Code("001");

    private String city;
    private String location;

    public POWCampLocation() {
    	super();
    }
    
    public String getCity()
    {
        return this.city;
    }

    /* Used by Hibernate */
    private void setCity(String city)
    {
        this.city = city;
    }

    public String getLocation()
    {
        return this.location;
    }

    /* Used by Hibernate */
    private void setLocation(String location)
    {
        this.location = location;
    }

    /**
     * Returns the camp name and location.
     *
     * @return the site number and name.
     */
    public String getNameAndLocation()
    {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty(getName()))
        {
            buffer.append(getName());
        }
        if (StringUtils.isNotEmpty(getLocation()))
        {
            if (buffer.length() > 0)
            {
                buffer.append(" - ");
            }
            buffer.append(getLocation());
        }
        return buffer.toString();
    }

    public static class Code extends AbstractCode
    {
        /**
         * An instance of serialVersionUID
         */
        private static final long serialVersionUID = 3832220692793503662L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
}
