/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Jan 4, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class PHDataSource extends AbstractNamedActiveLookup {	                                            
	
    private static final long serialVersionUID = -4505171006875896636L;
    
	public static final Code VETERAN = new Code("1");
	public static final Code SITE = new Code("2");
	public static final Code OTHER = new Code("3");
	public static final Code DOD = new Code("4");
	public static final Code VBA = new Code("5");    
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -7680501685742165648L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	public PHDataSource() {
		super();
	}
}

