/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   KATIKM
 * Represents OEF OIF source
 * Version 3.0
 */
public class OEFOIFSource extends AbstractNamedLookup {

	private static final long serialVersionUID = -8677518154370394642L;

	//FHIE 	Federal Health Information Exchange Program
	public static final Code CODE_FEDERAL_HEALTH_INFORMATION_EXCHANGE_PROGRAM = new Code("FHIE");

	//VIS 	Veteran Information System
	public static final Code CODE_VETERAN_INFORMATION_SYSTEM = new Code("VIS");

	//EM	Environmental Medicine
	public static final Code CODE_ENVIRONMENTAL_MEDICINE = new Code("EM");

	//CEV	Centralized Eligibility Verification
	public static final Code CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION = new Code("CEV");
	
	//VAMC	VAMC
	public static final Code CODE_VAMC = new Code("VAMC");
	
	//Inner class
	public static class Code extends AbstractCode {

		private static final long serialVersionUID = 3190814892504233780L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public OEFOIFSource() {
		super();
	}
}
