/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents an NCOA Zip Code Plus 4 Match Code.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class NcoaZipMatch extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = -4565516989768750050L;

    /* Building/High-Rise Record */
    public static final Code CODE_BUILDING_HIGH_RISE_RECORD = new Code("H");

    /* Default High-Rise Record */
    public static final Code CODE_DEFAULT_HIGH_RISE_RECORD = new Code("L");

    /* Postmaster Record */
    public static final Code CODE_POSTMASTER_RECORD = new Code("M");

    /* PO Box Record */
    public static final Code CODE_PO_BOX_RECORD = new Code("P");

    /* Rural Route Record */
    public static final Code CODE_RURAL_ROUTE_RECORD = new Code("R");

    /* Street Record */
    public static final Code CODE_STREET_RECORD = new Code("S");

    /* Unable to apply Zip + 4 */
    public static final Code CODE_UNABLE_TO_APPLY_ZIP_PLUS_4 = new Code("U");

    /* Unable to Correct Zip Code */
    public static final Code CODE_UNABLE_TO_CORRECT_ZIP_CODE = new Code("X");

    /* Firm Record */
    public static final Code CODE_FIRM_RECORD = new Code("F");

    /* General Delivery Code */
    public static final Code CODE_GENERAL_DELIVERY_CODE = new Code("G");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 3492162605430759272L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public NcoaZipMatch()
    {
        super();
    }
}
