/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an NCOA Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class NcoaStatus extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 343561713555441766L;

    /* Not Sent to NCOA Code */
    public static final Code CODE_NOT_SENT_TO_NCOA = new Code("3");

    /* New Code */
    public static final Code CODE_NEW = new Code("1");

    /* NCOA Checked Code */
    public static final Code CODE_NCOA_CHECKED = new Code("2");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -2670598868931384368L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public NcoaStatus()
    {
        super();
    }
}
