/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an NCOA Delivery Code.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class NcoaDeliveryCode extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 5727839178179108844L;

    /* DCOA Nixie Match (Not Using DCOA) Code */
    public static final Code CODE_DCOA_NIXIE_MATCH = new Code("E");

    /* Foreign Move Code */
    public static final Code CODE_FOREIGN_MOVE = new Code("F");

    /* Box Closed, No Forward Address Given Code */
    public static final Code CODE_BOX_CLOSED_NO_FORWARD_ADDRESS_GIVEN = new Code("G");

    /* Moved, left no forwarding address Code */
    public static final Code CODE_MOVED_LEFT_NO_FORWARDING_ADDRESS = new Code("K");

    /* COA Send HL7 Code */
    public static final Code CODE_COA_SEND_HL7 = new Code("M");

    /* NCOA Nixie Match (AAC Not Getting These) Code */
    public static final Code CODE_NCOA_NIXIE_MATCH = new Code("N");

    /* Original Address Not On DSF Code */
    public static final Code CODE_ORIGINAL_ADDRESS_NOT_ON_DSF = new Code("P");

    /* COA, Secondary Value Not Found Code */
    public static final Code CODE_COA_SECONDARY_VALUE_NOT_FOUND = new Code("S");

    /* Unknown Code */
    public static final Code CODE_UNKNOWN = new Code("U");

    /* Address Does Not Have NCOA Match Code */
    public static final Code CODE_ADDRESS_DOES_NOT_HAVE_NCOA_MATCH = new Code("X");

    /* Address Good No Address Change Code */
    public static final Code CODE_ADDRESS_GOOD_NO_ADDRESS_CHANGE = new Code("1");

    /* DCOA Match Forwardable Move (Not Using DCOA) Code */
    public static final Code CODE_DCOA_MATCH_FORWARDABLE_MOVE = new Code("D");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 1501138884562009657L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public NcoaDeliveryCode()
    {
        super();
    }
}
