package gov.va.med.esr.common.model.lookup;


import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class NamedContingency extends AbstractNamedActiveLookup {

	/**
	 * 
	 */
	private static final long serialVersionUID = 9087333793768213710L;
	/*
	 * Operation Southern Watch in Saudi Arabia, Operation Desert Thunder in Southern Iraq
	 */
	public static final Code OP_SOUTHWATCH_ARABIA_DESERTTHUNDER_IRAQ = new Code("9BU");
	/*
	 * Operation Uphold Democracy in Haiti
	 */
	public static final Code OP_UPHOLD_DEMOCRACY_HAITI = new Code("9EC");
	/*
	 * Operation Joint Endeavor in Bosnia Herzegovina
	 */
	public static final Code OP_JOINT_ENDEAVOR_BOSNIA_HERZEGOVINA = new Code("9EV");
	/*
	 * Operation Joint Forge in the Persian Gulf
	 */
	public static final Code OP_JOINT_FORGE_PERSIAN_GULF = new Code("9FF");	
	/*
	 * Operation Allied Force in Kosovo
	 */
	public static final Code OP_ALLIED_FORCE_KOSOVO = new Code("9FS");
	/*
	 * Operation Joint Guardian in Kosovo
	 */
	public static final Code OP_JOINT_GUARDIAN_KOSOVO = new Code("9FV");
	/*
	 * Operation Enduring Freedom in Afghanistan, 
	 * Operation Iraqi Freedom in Iraq, 
	 * Operation Noble Eagle in United States
	 */
	public static final Code OEF_OIF_NOBLE_EAGLE = new Code("9GF");
	/*
	 * Disaster relief for Hurricane Katrina
	 */
	public static final Code DISASTER_RELIEF_HURRICANE_KATRINA = new Code("9GY");	
	/*
	 * Disaster relief for Hurricane Wilma
	 */
	public static final Code DISASTER_RELIEF_HURRICANE_WILMA = new Code("9HA");
	/*
	 * Disaster relief for Hurricane Rita
	 */
	public static final Code DISASTER_RELIEF_HURRICANE_RITA = new Code("9HB");
	/*
	 * Relief to Pakistan
	 */
	public static final Code RELIEF_TO_PAKISTAN = new Code("9HC");
		
		
	public static class Code extends AbstractCode
	{

		/**
		 * 
		 */
		private static final long serialVersionUID = -6051212728731683736L;

		/**
		 * 
		 */
		private Code(String code)
		{
			super(code);
		}

		public static Code getByCode(String code)
		{
			return (Code)getCode(Code.class, code);
		}
	}


	/**
	 * Default Constructor  
	 */
	public NamedContingency() {
		super();
	}

}
