package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

//Java Classes

//Library Classes

//Framework Classes

/**
 * @author Commons Team
 * 
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="NAME_TYPE" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class NameType
    extends AbstractNamedActiveLookup
{
	private static final long serialVersionUID = 1260312950691610847L;
    public static final Code ALIAS_NAME = new Code("A");
	public static final Code BIRTH_NAME = new Code("B");
	public static final Code ADOPTED_NAME = new Code("C");
	public static final Code DISPLAY_NAME = new Code("D");
	public static final Code LICENSING_NAME = new Code("I");
	public static final Code LEGAL_NAME = new Code("L");
	public static final Code MAIDEN_NAME = new Code("M");
	public static final Code NICKNAME = new Code("N");
	public static final Code PARTNER_SPOUSE_NAME = new Code("P");
	public static final Code REGISTERED_NAME = new Code("R");
	public static final Code CODED_PSEUDO_NAME = new Code("S");
	public static final Code TRIBAL_NAME = new Code("T");
	public static final Code UNSPECIFIED = new Code("U");
	
	public static class Code extends AbstractCode {
		private static final long serialVersionUID = -4321292436675712809L;
        
        private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
	
    /**
     * Default constructor.
     */
    public NameType()
    {
        super();
    }
}