/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Nose Throat Radium Verficiation Method.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class NTRVerificationMethod extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 3266092382218522762L;

    /* Qualifying Military Service Code */
    public static final Code CODE_QUALIFYING_MILITARY_SERVICE = new Code("S");

    /* Military Record Code */
    public static final Code CODE_MILITARY_RECORD = new Code("M");

    /* Not Qualified Code */
    public static final Code CODE_NOT_QUALIFIED = new Code("N");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -7676724679399134536L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public NTRVerificationMethod()
    {
        super();
    }
}