package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

public class MsdsCountry extends AbstractNamedLookup{
	
	private static final long serialVersionUID = -4415580861952529140L;
	
	public static final Code CODE_USA = new Code("US");
	
	 public static final Code CODE_PHILIPPINES = new Code("RP");
	
	/*define the codes as required */
	
	public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 3021238010553550137L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }
	
	public MsdsCountry() {
		super();
	}

}
