package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is a zipcode to msa lookup class. This class represents a msacode.
 *
 * @author 
 * @version 1.0
 */
public class MsaCode extends AbstractNamedActiveLookup
{
    
    
    /**
     * 
     */
    private static final long serialVersionUID = -2689051080448713081L;

    private String zipCode;

    private String msaCode;
    
    private int version;
    

    /**
     * Default constructor.
     */
    public MsaCode()
    {
        super();
    }

    public String getZipCode()
    {
        return zipCode;
    }

    public void setZipCode(String zipCode)
    {
        this.zipCode = zipCode;
    }

    public String getMsaCode()
    {
        return msaCode;
    }

    public void setMsaCode(String msaCode)
    {
        this.msaCode = msaCode;
    }

    public int getVersion()
    {
        return version;
    }

    public void setVersion(int version)
    {
        this.version = version;
    }

    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder.append("zipCode",
            this.zipCode).append("msaCode",
            this.msaCode));
    }

    public void setName(String name)
    {
        if (name != null)
        {
            name = name.toUpperCase();
        }
        super.setName(name);
    }

    public void setDescription(String description)
    {
        if (description != null)
        {
            description = description.toUpperCase();
        }
        super.setDescription(description);
    }
}