/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;


// Java classes

// Library classes

// Framework classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class Month extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6752562434662828258L;	                                            

	public static final Code JANUARY = new Code("1");
	public static final Code FEBRUARY = new Code("2");
	public static final Code MARCH = new Code("3");
	public static final Code APRIL = new Code("4");
	public static final Code MAY = new Code("5");
	public static final Code JUNE = new Code("6");
	public static final Code JULY = new Code("7");
	public static final Code AUGUST = new Code("8");
	public static final Code SEPTEMBER = new Code("9");
	public static final Code OCTOBER = new Code("10");
	public static final Code NOVEMBER = new Code("11");
	public static final Code DECEMBER = new Code("12");
	
    public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 5249164439382941277L;	                                            
		
		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
    public Month() {
    	super();
    }
}


