/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Monetary Benefit Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class MonetaryBenefitType extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = 5763501942921419482L;

    /* Housebound Code */
    public static final Code CODE_HOUSEBOUND = new Code("HB");

    /* VA Pension Code */
    public static final Code CODE_VA_PENSION = new Code("PN");

    /* Aid and Attendance Code */
    public static final Code CODE_AID_AND_ATTENDANCE = new Code("AA");

    /* Disability Compensation Code */
    public static final Code CODE_DISABILITY_COMPENSATION = new Code("DC");

    /* Total Annual VA Check Amount Code */
    // Not in reference data list
    // public static final Code CODE_TOTAL_ANNUAL_VA_CHECK_AMOUNT = new Code("TA");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -69582592710028567L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public MonetaryBenefitType()
    {
        super();
    }
}
