/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Military Sexual Trauma Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class MilitarySexualTraumaStatus extends AbstractNamedActiveLookup
{
    private static final long serialVersionUID = -1624276349824455695L;

    /* Unknown, Not Screened Code */
    public static final Code CODE_UNKNOWN_NOT_SCREENED = new Code("U");

    /* Screened, Reports MST Code */
    public static final Code CODE_SCREENED_REPORTS_MST = new Code("Y");

    /* Screened, Declines To Answer Code */
    public static final Code CODE_SCREENED_DECLINES_TO_ANSWER = new Code("D");

    /* Screened, Does Not Report MST Code */
    public static final Code CODE_SCREENED_DOES_NOT_REPORT_MST = new Code("N");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = 280244381794467510L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public MilitarySexualTraumaStatus()
    {
        super();
    }
}
