/**
 * 
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author DNS   KATIKM
 * Represents MilitaryServiceComponent
 * Version 3.1
 */
public class MilitaryServiceComponent extends AbstractNamedLookup {

	private static final long serialVersionUID = -1669977796652488558L;

	//R	Regular
	public static final Code CODE_REGULAR = new Code("R");

	//V	Activated Reserve
	public static final Code CODE_ACTIVATED_RESERVE = new Code("V");

	//G	Activated National Guard
	public static final Code CODE_ACTIVATED_NATIONAL_GUARD = new Code("G");
	
	//Inner class
	public static class Code extends AbstractCode {

		private static final long serialVersionUID = 4743630087113442263L;

        private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public MilitaryServiceComponent() {
		super();
	}	
}
