package gov.va.med.esr.common.model.lookup;

//Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// ESR Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * @author Commons Team
 * 
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="MESSAGE_TYPES" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class MessageType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -877906533372506057L;

	/* 
	 *******************  Query Messages ***********************  
	 */
	public static final Code CODE_QRYZ07_TO_SITE = new Code("QRYZ07-S");

	public static final Code CODE_QRYZ10_TO_ESR = new Code("QRYZ10-E");

	public static final Code CODE_QRYZ11_TO_ESR = new Code("QRYZ11-E");

	public static final Code CODE_QRYZ11_TO_MVR = new Code("QRYZ11-M");
	
	//Seeding Changes
	public static final Code CODE_QRYZ21_TO_SITE = new Code("QBPQ21-S");
	

	/* 
	 *******************  Unsolicitated Messages ***********************  
	 */
	/**
	 * An instance of CODE_ORUZ04 to Vista Sites
	 */	
	public static final Code CODE_ORUZ04_TO_SITE = new Code("ORUZ04-S");
	
	/**
	 * An instance of CODE_ORUZ05 to Vista Sites
	 */	
	public static final Code CODE_ORUZ05_TO_SITE = new Code("ORUZ05-S");
	
	/**
	 * An instance of CODE_ORUZ05 to ESR
	 */	
	public static final Code CODE_ORUZ05_TO_ESR = new Code("ORUZ05-E");
	/**
	 * An instance of CODE_ORUZ06 to Vista Sites
	 */	
	public static final Code CODE_ORUZ06_TO_SITE = new Code("ORUZ06-S");
	
	/**
	 * An instance of CODE_ORUZ07 to ESR
	 */
	public static final Code CODE_ORUZ07_TO_ESR = new Code("ORUZ07-E");

	/**
	 * An instance of CODE_ORUZ10 to ESR
	 */
	public static final Code CODE_ORUZ10_TO_SITE = new Code("ORUZ10-S");

	/**
	 * An instance of CODE_ORUZ11 to ESR
	 */
	public static final Code CODE_ORUZ11_TO_ESR = new Code("ORUZ11-E");

	/**
	 * An instance of CODE_ORUZ11 to Vista sites
	 */
	public static final Code CODE_ORUZ11_TO_SITE = new Code("ORUZ11-S");
	
	/**
	 * An instance of CODE_ORUZ12 to ESR
	 */
	public static final Code CODE_ORUZ12_TO_ESR = new Code("ORUZ12-E"); 

	/**
	 * An instance of CODE_ORUZ13 to ESR
	 */
	public static final Code CODE_ORUZ13_TO_ESR = new Code("ORUZ13-E");	
	
	/**
	 * Seeding Changes: An instance of CODE_RSPK21 to ESR
	 */
	public static final Code CODE_RSPK21_TO_ESR = new Code("RSPK21-E");
	
	/* 
	 *******************  Solicitated Messages ***********************  
	 */
	
	/**
	 * An instance of CODE_ORFZ07 to ESR
	 */
	public static final Code CODE_ORFZ07_TO_ESR = new Code("ORFZ07-E");

	/**
	 * An instance of CODE_ORFZ10 to Vista sites
	 */	
	public static final Code CODE_ORFZ10_TO_SITE = new Code("ORFZ10-S");
	
	/**
	 * An instance of CODE_ORFZ11 to ESR 
	 */
	public static final Code CODE_ORFZ11_TO_ESR = new Code("ORFZ11-E");

	/**
	 * An instance of CODE_ORFZ11 to Vista sites
	 */	
	public static final Code CODE_ORFZ11_TO_SITE = new Code("ORFZ11-S");
	
	/**
	 * An instance of CODE_MFNZEG to Vista sites
	 */	
	public static final Code CODE_MFNZEG_TO_SITE = new Code("MFNZEG-S");

    /**
     * EDB Communication Errors to EDB
     */
    public static final Code CODE_COM_ERROR = new Code("COMERR-E");

    /**
     * EDB Communication Rejects to EDB
     */
    public static final Code CODE_COM_REJECT = new Code("COMREJ-E");

    /**
     * EDB Communication Address Update to EDB
     */
    public static final Code CODE_COM_ADDRESS_UPDATE = new Code("COMADD-E");


    /**
	 * A look up code encapsulate description and code
	 */
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2777959250780427951L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * The direction of the message (I/O).
	 * 
	 * @hibernate.property not-null="true" insert="false" update="false"
	 *                     column="DIRECTION" length="1"
	 */
	private String direction;

	/**
	 * Default constructor.
	 */
	public MessageType() {
		super();
	}

	/**
	 * Returns the direction of the message (I/O).
	 * 
	 * @return The direction of the message (I/O).
	 */
	public String getDirection() {
		return this.direction;
	}

    public String getCodeDescription() {
        return this.getCode() + " : " + this.getDescription();
    }
    
	/**
	 * Sets the direction of the message (I/O).
	 * 
	 * @param direction
	 *            The direction of the message (I/O).
	 */
	private void setDirection(String direction) {
		this.direction = direction;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.common.model.AbstractLookup#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();

		this.direction = null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.common.model.lookup.CodedDescriptionLookup#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("direction", this.direction);
	}
}