package gov.va.med.esr.common.model.lookup;

//Java Classes

//Library Classes

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * @author Commons Team
 * 
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="STATUS" where="MESSAGE_STATUS_IND = 1"
 *                  mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class MessageStatus extends AbstractNamedActiveLookup {
	private static final long serialVersionUID = -3176592664375025646L;
    
    public static final Code COMPLETE = new Code("01");
	public static final Code AWAITING_TRANSMISSION = new Code("02");
	public static final Code AWAITING_ACKNOWLEDGEMENT = new Code("03");
	public static final Code PENDING = new Code("04");
	public static final Code RETRANSMIT = new Code("05");
	public static final Code NOT_TRANSMITTED = new Code("06");
	public static final Code ERROR = new Code("07");
	public static final Code RETRANSMISSION_FAILED = new Code("08");
	
	public static class Code extends AbstractCode {
		private static final long serialVersionUID = 2297169316137040352L;
        
        private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
   /**
    * Default constructor.
    */
   public MessageStatus() {
      super();
   }
}