package gov.va.med.esr.common.model.lookup;


import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class MHDocumentType extends AbstractNamedActiveLookup {

	/**
	 * 
	 */
	private static final long serialVersionUID = 48532119115483331L;
	
	/**
	 * Should use same SDS table mapped to PHDocumentType since that
	 * was meant to be generic
	 */
	public static final Code CODE_DD214 = new Code("1");
	public static final Code CODE_DD215 = new Code("2");
	public static final Code CODE_WD_AGO_FORM = new Code("3");
	public static final Code CODE_MILITARY_ORDERS_OF_AWARD = new Code("4");
	public static final Code CODE_OTHER_OFFICIAL_SVC_RECORDS = new Code("5");
	public static final Code CODE_VBA_DOD_FILE = new Code("6");	
	
	public static class Code extends AbstractCode
	{
	
		/**
		 * 
		 */
		private static final long serialVersionUID = -1225795248145980145L;

		private Code(String code)
		{
			super(code);
		}

		public static Code getByCode(String code)
		{
			return (Code)getCode(Code.class, code);
		}
	}

	/**
	 * Default Constructor
	 */
	public MHDocumentType() {
		super();
	}	
	
}
