package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * 
 * @author DNS   ruizc
 * @version 1.0
 *
 */
public class MHDataSource extends AbstractNamedActiveLookup {
	/**
	 * 
	 */
	private static final long serialVersionUID = 3024929887978226541L;

	public static final Code VADIR = new Code("00");	

	public static final Code WEBHINQ = new Code("01");
	
	public static final Code VBA  = new Code("02");	

	public static final Code OTHER = new Code("03");
	
	
	public static class Code extends AbstractCode
	{
	
		/**
		 * 
		 */
		private static final long serialVersionUID = -5886978593484596370L;

		private Code(String code)
		{
			super(code);
		}

		public static Code getByCode(String code)
		{
			return (Code)getCode(Code.class, code);
		}
	}

	/**
	 * Default Constructor
	 */
	public MHDataSource() {
		super();
	}	
		
}
