/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/


package gov.va.med.esr.common.model.lookup;

import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang.Validate;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;

import gov.va.med.esr.service.LookupService;

/**
 * Initial javadoc for class LookupServiceConverter.
 * TODO - Add content here
 * 
 * Created Feb 2, 2006 5:27:24 PM
 * @author DNS   BOHMEG
 */
public class LookupServiceConverter extends AbstractComponent implements Converter {
	private LookupService lookupService;

	/* (non-Javadoc)
	 * @see org.apache.commons.beanutils.Converter#convert(java.lang.Class, java.lang.Object)
	 */
	public Object convert(Class clazz, Object code) {
		if(code instanceof Lookup)
			return code;
		
		Lookup obj = null;
		try {
			if(code != null) {
				obj = lookupService.getByCode(clazz, code.toString());
			}
		}catch(Exception e) {
			throw new ConversionException("Unable to get the Lookup object for code[" + code +"] of class: " + clazz.getName());
		}
		return obj;
	}

	/**
	 * @return Returns the lookupService.
	 */
	public LookupService getLookupService() {
		return lookupService;
	}

	/**
	 * @param lookupService The lookupService to set.
	 */
	public void setLookupService(LookupService lookupService) {
		this.lookupService = lookupService;
	}

	public void afterPropertiesSet() {
		Validate.notNull(lookupService, "A LookupService is required");
	}
	
	public LookupServiceConverter() {
		super();
	}
}
