package gov.va.med.esr.common.model.lookup;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.StringUtils;



/**
 * @author Commons Team
 * 
 */
public class Language extends AbstractNamedActiveLookup
{

    /**
     * An instance of serialVersionUID
     */
    private static final long serialVersionUID = 7440110864514773007L;
   
    //TODO: May need static values 
    public static final String DEFAULT_LANGUAGE_CODE = "eng";    

    private String code1;
    
    /**
     * Default constructor.
     */
    public Language()
    {
        super();
    }
    
    /**
     * Get Code 1.
     * @return the code1
     */
    public String getCode1() {
        return code1;
    }

    /**
     * Set Code 1.
     * @param code1 the code1 to set
     */
    public void setCode1(String code1) {
        this.code1 = code1;
    }

    public static class Code extends AbstractCode {

        /**
         * 
         */
        private static final long serialVersionUID = -8449008165242765949L;

        /**
         * An instance of serialVersionUID
         */
        
        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }   

    public String getCodeAndDescription()
    {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty(getCode()))
        {
            buffer.append(getCode());
        }
        if (StringUtils.isNotEmpty(getDescription()))
        {
            if (buffer.length() > 0)
            {
                buffer.append(" - ");
            }
            buffer.append(getDescription());
        }
        return buffer.toString();
    }    
}