/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Insured Relationship.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class InsuredRelationship extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */    
    private static final long serialVersionUID = 4656246879329070119L;

    /* For Veteran Code */
    public static final Code CODE_VETERAN = new Code("v");

    /* For Spouse Code */
    public static final Code CODE_SPOUSE = new Code("s");
    
    /* For Other Code */
    public static final Code CODE_OTHER = new Code("o");

    public static class Code extends AbstractCode
    {
        private static final long serialVersionUID = -338585350252511264L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public InsuredRelationship()
    {
        super();
    }
}
