/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Insurance Plan Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class InsurancePlanType extends AbstractNamedActiveLookup
{
    /**
     * An instance of serialVersionUID
     */    
    private static final long serialVersionUID = 5720617524971867496L;

    /* Medicare (M) Code */
    public static final Code CODE_MEDICARE_M = new Code("33");

    /* Health Maintenance Organization (HMO) Code */
    public static final Code CODE_HMO = new Code("18");

    /* Major Medical Expense Insurance Code */
    public static final Code CODE_MAJOR_MEDICAL_EXPENSE_INSURANCE = new Code("27");

    /* Medicaid Code */
    public static final Code CODE_MEDICAID = new Code("29");

    /* Blue Cross / Blue Shield Code */
    public static final Code CODE_BCBS = new Code("3");

    /* Preferred Provider Organization (PPO) Code */
    public static final Code CODE_PPO = new Code("40");

    public static class Code extends AbstractCode
    {
        /**
         * An instance of serialVersionUID
         */        
        private static final long serialVersionUID = 2359288110274292567L;

        private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public InsurancePlanType()
    {
        super();
    }
}
