/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Conflict Location.
 *
 * @author DNS   CHENJ2
 * @version 3.0
 */
public class Indicator extends AbstractNamedActiveLookup {
 
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8196682634988257093L;

	/* No */
    public static final Code NO = new Code("0");

	/* Yes*/
    public static final Code YES = new Code("1");
    
	/* Unknown */
    public static final Code UNKNOWN = new Code("2");

    // ***** TODO *****
    // Remove this and use correctly spelled one above
    public static final Code UNKOWN = UNKNOWN;


	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 8034768661193412476L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
	
	private String alphaCode = null;

    /**
     * Default constructor.
     */
    public Indicator()
    {
        super();
    }
    
    /**
     * Return true for 1|y false for 0/n and null for unknown/2
     * @return
     */
    public Boolean toBoolean() {
    	if (YES.getCode().equals(this.getCode())){
    		return Boolean.TRUE;    		
    	}else if (NO.getCode().equals(this.getCode())){
    		return Boolean.FALSE;
    	}else {
    		return null;
    	}
    }
    public String getAlphaCode() {
		return this.alphaCode;
	}
    
	public void setAlphaCode(String alphaCode) {
		this.alphaCode = alphaCode;
	}

}