package gov.va.med.esr.common.model.lookup;

//Java Classes

//Library Classes

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * @author Commons Team
 * 
 */
public class IncomeType extends AbstractNamedActiveLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -6776995121380235167L;

	public static final Code INCOME_TYPE_SOCIAL_SECURITY = new Code("1");
	public static final Code INCOME_TYPE_CIVIL_SERVICE = new Code("2");
	public static final Code INCOME_TYPE_RAILROAD_RETIREMENT = new Code("3");
	public static final Code INCOME_TYPE_MILITARY_RETIREMENT = new Code("4");
	public static final Code INCOME_TYPE_UNEMPLOYMENT_COMPENSATION = new Code("5");
	public static final Code INCOME_TYPE_OTHER_RETIREMENT = new Code("6");
	public static final Code INCOME_TYPE_TOTAL_INCOME_FROM_EMPLOYMENT =new Code("7");
	public static final Code INCOME_TYPE_INTEREST_DIVIDEND_ANNUITY =new Code("8");
	public static final Code INCOME_TYPE_WORKERS_COMP_BLACK_LUNG =new Code("9");
	public static final Code INCOME_TYPE_TOTAL_ALL_OTHER_INCOME =new Code("10");
	public static final Code INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME = new Code("13");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 8365779535945883298L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public IncomeType() {
		super();
	}
}