/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Income Test Type.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class IncomeTestType extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 6398525754063882764L;

	/* LTC Co-Pay Test Code */
    public static final Code CODE_LTC_CO_PAY_TEST = new Code("3");

    /* LTC Co-Pay Exemption Test Code */
    public static final Code CODE_LTC_CO_PAY_EXEMPTION_TEST = new Code("4");

    /* Means Test Code */
    public static final Code CODE_MEANS_TEST = new Code("1");

    /* Co-Pay Exemption Test Code */
    public static final Code CODE_CO_PAY_EXEMPTION_TEST = new Code("2");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3881320256897895838L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public IncomeTestType()
    {
        super();
    }
}
