package gov.va.med.esr.common.model.lookup;

//Java Classes

//Library Classes

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.model.lookup.AbstractCode;


/**
 * @author Commons Team
 * 
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="RECORD_SOURCE" where="INCOME_TEST_SOURCE_IND = 1"
 *                  mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class IncomeTestSource extends AbstractNamedActiveLookup {
	
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8817637961302291985L;
	
	public static final Code CODE_VAMC = new Code("1");
    public static final Code CODE_IVM = new Code("2");
    public static final Code CODE_HEC = new Code("3");
    public static final Code CODE_OTHER = new Code("4");   
    
    public static final Code CODE_VOA = new Code("6");
	
   /**
    * Default constructor.
    */
	
   public IncomeTestSource() {
      super();
   }
   public static class Code extends AbstractCode
   {
       /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6148738188075794884L;

		private Code(String code)
       {
           super(code);
       }

       public static Code getByCode(String code)
       {
           return (Code)getCode(Code.class, code);
       }
   }   
}