package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

//Java Classes

//Library Classes

//Framework Classes

/**
 * @author Commons Team
 * 
 * @hibernate.mapping auto-import="true" default-cascade="all"
 * @hibernate.class table="GENDER" mutable="false"
 * @hibernate.cache usage="read-only"
 */
public class Gender
    extends AbstractNamedActiveLookup
{
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4122853670739235892L;
	public static final Code AMBIGUOUS = new Code("A");
	public static final Code FEMALE = new Code("F");
	public static final Code MALE = new Code("M");
	public static final Code NOT_APPLICABLE = new Code("N");
	public static final Code OTHER = new Code("O");
	public static final Code UNKNOWN = new Code("U");
	public static final Code UNDIFFERENTIATED = new Code("UN");
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 641469652092111868L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	
	
    /**
     * Default constructor.
     */
    public Gender()
    {
        super();
    }
}