/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

public class FunctionalGroup extends AbstractNamedActiveLookup {

    private static final long serialVersionUID = -5688341295554964095L;
    
    public static final Code EE = new Code("1","EE"); //Enrollment Eligibility
    public static final Code DQ = new Code("2","DQ"); //Data Quality
    
    public FunctionalGroup() {
        super();
    }
    public String getAlias(){
    	return Code.getByCode(getCode()).getAlias();
    }
    public static class Code extends AbstractCode {

        private static final long serialVersionUID = 1026377053557812826L;

        private Code(String code) {
            super(code);
        }
        private Code( String code, String alias ) {
            super( code, alias );
        }
        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }
}
