/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM).
 * This class represents a Period of Service.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class FilipinoVeteranProof extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1321766276505270663L;

	/* Report Of Birth Abroad Of US Citizen Code */
    public static final Code CODE_BIRTH_ABROAD_OF_US_CITIZEN = new Code("BA");

    /* US Birth Certificate Code */
    public static final Code CODE_US_BIRTH_CERTIFICATE = new Code("BC");

    /* Verification of Naturalization Code */
    public static final Code CODE_VERIFICATION_OF_NATURALIZATION = new Code("NA");

    /* No Proof Code */
    public static final Code CODE_NO_PROOF = new Code("NO");

    /* US Passport Code */
    public static final Code CODE_US_PASSPORT = new Code("PP");

    /* Verification of Permanent Residency Code */
    public static final Code CODE_VERIFICATION_OF_PERMANENT_RESIDENCY = new Code("PR");

    /* VA Compensation At Full Dollar Rate Code */
    public static final Code CODE_VA_COMPENSATION_AT_FULL_DOLLAR_RATE = new Code("VA");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 6545229480157151438L;
		private Code(String code) {	super(code); }
		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}	

    /**
     * Default constructor.
     */
    public FilipinoVeteranProof()
    {
        super();
    }
}

