/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classses
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Fee Basis Program.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class FeeBasisTreatmentType extends AbstractNamedActiveLookup 
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 5785532911964931593L;

	/* I.D. Card Status Code */
    public static final Code CODE_ID_CARD_STATUS = new Code("3");

    /* State Home Code */
    public static final Code CODE_STATE_HOME = new Code("4");

    /* Short Term Fee Status Code */
    public static final Code CODE_SHORT_TERM_FEE_STATUS = new Code("1");

    /* Home Nursing Services Code */
    public static final Code CODE_HOME_NURSING_SERVICES = new Code("2");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -4495867126310193264L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public FeeBasisTreatmentType()
    {
        super();
    }
}
