/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes

// Framework classses
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents a Fee Basis Program.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class FeeBasisProgram extends AbstractNamedActiveLookup 
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8574288830153902013L;

	/* Home Health Services Code */
    public static final Code CODE_HOME_HEALTH_SERVICES = new Code("11");

    /* Other Institutional Services Code */
    public static final Code CODE_OTHER_INSTITUTIONAL_SERVICES = new Code("12");

    /* Dialysis Code */
    public static final Code CODE_DIALYSIS = new Code("13");

    /* Oxygen Services Code */
    public static final Code CODE_OXYGEN_SERVICES = new Code("14");

    /* State Home Code */
    public static final Code CODE_STATE_HOME = new Code("15");

    /* Outpatient Code */
    public static final Code CODE_OUTPATIENT = new Code("2");

    /* Pharmacy Code */
    public static final Code CODE_PHARMACY = new Code("3");

    /* Comp & Pension Code */
    public static final Code CODE_COMP_AND_PENSION = new Code("4");

    /* Dental Code */
    public static final Code CODE_DENTAL = new Code("5");

    /* Civil Hospital Code */
    public static final Code CODE_CIVIL_HOSPITAL = new Code("6");

    /* Contract Nursing Home Code */
    public static final Code CODE_CONTRACT_NURSING_HOME = new Code("7");

    /* Champva Code */
    public static final Code CODE_CHAMPVA = new Code("8");

    /* Contract Readjustment Counseling Code */
    public static final Code CODE_CONTRACT_READJUSTMENT_COUNSELING = new Code("9");

    /* Inpatient Code */
    public static final Code CODE_INPATIENT = new Code("1");

    /* Contract Halfway Houses Code */
    public static final Code CODE_CONTRACT_HALFWAY_HOUSES = new Code("10");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3291906208280036181L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public FeeBasisProgram()
    {
        super();
    }
}

