/********************************************************************
 * Copyright  2007 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

/**
 * @author Muddaiah Ranga
 * @version 1.0
 */
public class EnrollmentStatusComponent extends AbstractNamedLookup {

	private static final long serialVersionUID = -930926104740173937L;
	
    public static final Code CODE_QUERY_SENT_TO_VBA = new Code("1");

    public static final Code CODE_QUERY_RETURN_TO_VBA = new Code("2");
    
    public static final Code CODE_ELIGIBILITY_VERIFIED = new Code("3");
    
    public static final Code CODE_ENROLLMENT_CREATED = new Code("4");
    
    public static final Code CODE_MESSAGE_ACCEPTED_AT_SITE = new Code("5");

    public static class Code extends AbstractCode {
        /**
         * An instance of serialVersionUID
         */
        private static final long serialVersionUID = -6852121223703591884L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }
    }
    
    public EnrollmentStatusComponent()
    {
        super();
    }
}

