/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import java.util.HashSet;
import java.util.Set;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Enrollment Status.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EnrollmentStatus extends AbstractNamedActiveLookup
{
    
    private static Set pendingEnrollmentStatuses = null;
    
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7256877646770529263L;

	/* Unverified Code */
    public static final Code CODE_UNVERIFIED = new Code("1");

    /* Verified Code */
    public static final Code CODE_VERIFIED = new Code("2");

    /* Inactive Code */
    public static final Code CODE_INACTIVE = new Code("3");

    /* Rejected Code */
    public static final Code CODE_REJECTED = new Code("4");

    /* Suspended Code */
    public static final Code CODE_SUSPENDED = new Code("5");

    /* Deceased Code */
    public static final Code CODE_DECEASED = new Code("6");

    /* Cancelled/Declined Code */
    public static final Code CODE_CANCELLED_DECLINED = new Code("7");

    /* Expired Code */
    public static final Code CODE_EXPIRED = new Code("8");

    /* Pending Code */
    public static final Code CODE_PENDING = new Code("9");

    /* Not Eligibile Code */
    public static final Code CODE_NOT_ELIGIBLE = new Code("10");

    /* Rejected; Fiscal Year Code */
    public static final Code CODE_REJECTED_FISCAL_YEAR = new Code("11");

    /* Rejected; Mid-Cycle Code */
    public static final Code CODE_REJECTED_MID_CYCLE = new Code("12");

    /* Rejected; Stop New Enrollments Code */
    public static final Code CODE_REJECTED_STOP_NEW_ENROLLMENTS = new Code("13");

    /* Rejected; Initial Application By VAMC Code */
    public static final Code CODE_REJECTED_INITIAL_APPLICATION_BY_VAMC = new Code("14");

    /* Pending; No Eligibility Code in VIVA Code */
    public static final Code CODE_PENDING_NO_ELIGIBILITY_CODE_IN_VIVA = new Code("15");

    /* Pending; Means Test Required Code */
    public static final Code CODE_PENDING_MEANS_TEST_REQUIRED = new Code("16");

    /* Pending; Eligibility Status Is Unverified Code */
    public static final Code CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED = new Code("17");

    /* Pending; Other Code */
    public static final Code CODE_PENDING_OTHER = new Code("18");

    /* Not Eligible; Refused To Pay Co-pay Code */
    public static final Code CODE_NOT_ELIGIBLE_REFUSED_TO_PAY_COPAY = new Code("19");

    /* Not Eligible; Ineligible Date Code */
    public static final Code CODE_NOT_ELIGIBLE_INELIGIBLE_DATE = new Code("20");

    /* Pending; Purple Heart Unconfirmed Code */
    public static final Code CODE_PENDING_PURPLE_HEART_UNCONFIRMED = new Code("21");

    /* Rejected; Below Enrollment Group Threshold Code */
    public static final Code CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD = new Code("22");
    
    /* Not Applicable Code */
    public static final Code CODE_NOT_APPLICABLE = new Code("23");
    
    static
    {
        pendingEnrollmentStatuses = new HashSet();
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING.getName());
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING_NO_ELIGIBILITY_CODE_IN_VIVA.getName());
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING_MEANS_TEST_REQUIRED.getName());
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED.getName());
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING_OTHER.getName());
        pendingEnrollmentStatuses.add(EnrollmentStatus.CODE_PENDING_PURPLE_HEART_UNCONFIRMED.getName());
    }    

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6289784726584985550L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    private EnrollmentCategory enrollmentCategory = null;

    /**
     * Default constructor.
     */
    public EnrollmentStatus()
    {
        super();
    }

    public EnrollmentCategory getEnrollmentCategory()
    {
        return this.enrollmentCategory;
    }

    public void setEnrollmentCategory(EnrollmentCategory enrollmentCategory)
    {
        this.enrollmentCategory = enrollmentCategory;
    }

    public static Set getPendingEnrollmentStatuses() {
        return pendingEnrollmentStatuses;
    }
}
