/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class represents an Enrollment Source.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class EnrollmentSource extends AbstractNamedActiveLookup
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4336651069102462104L;

	/* Other VAMC Code */
    public static final Code CODE_OTHER_VAMC = new Code("3");

    /* VAMC Code */
    public static final Code CODE_VAMC = new Code("1");

    /* HEC Code */
    public static final Code CODE_HEC = new Code("2");

    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 3856092207833786233L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

    /**
     * Default constructor.
     */
    public EnrollmentSource()
    {
        super();
    }
}
