/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.common.model.lookup;

// Java classes

// Library classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedLookup;

// ESR classes

/**
 * This is one of the classes of the Business Object Model (BOM). This class
 * represents an Enrollment Process Status for reports.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class EnrollmentProcessStatus extends AbstractNamedLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1678691037959197615L;

	/* Complete Code */
	public static final Code CODE_COMPLETE = new Code("1");

	/* Incomplete Code */
	public static final Code CODE_INCOMPLETE = new Code("2");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -6852121223703591884L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}

	/**
	 * Default constructor.
	 */
	public EnrollmentProcessStatus()
    {
		super();
	}
}
