/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.common.model.lookup;

//Framework Classes
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

/**
 * @author Commons Team
 * @version 1.0
 */
public class EnrollmentPrioritySubGroup
    extends AbstractNamedActiveLookup implements Comparable<EnrollmentPrioritySubGroup> {
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -1075042373840629566L;
	public static final Code SUBGROUP_A = new Code("1");
	public static final Code SUBGROUP_B = new Code("2");
	public static final Code SUBGROUP_C = new Code("3");
	public static final Code SUBGROUP_D = new Code("4");
	public static final Code SUBGROUP_E = new Code("5");
    public static final Code SUBGROUP_G = new Code("7");

    public static class Code
        extends AbstractCode {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 8380227659125134694L;

		private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code) getCode(Code.class, code);
        }

        public int compareTo(Object obj) {
        	if ( obj != null && obj instanceof Code ) {
        		String otherCode = ((Code)obj).getCode();
        		return getCode().compareTo(otherCode);
        	}
        	return 1;
        }
    }

    /**
     * Default constructor.
     */
    public EnrollmentPrioritySubGroup() {
        super();
    }
    
    public int compareTo(EnrollmentPrioritySubGroup other) {
        if (other != null)
            return getCode().compareTo(other.getCode());
        else
            return 1;
    }
}