/********************************************************************
 * Copyright  2006 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Mar 31, 2006
 *
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;

// Java classes

// Library classes

// Framework classes

// EDB Classes

/**
 * @author Yi He
 * @version 1.0
 */
public class EnrollmentOverrideReason extends AbstractNamedActiveLookup {

    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1709913693694393322L;
	
	public static final Code CODE_REJECT_OVERRIDE_AGREE_PAY = new Code("1");
	public static final Code CODE_REJECT_OVERRIDE_BACK_DATED = new Code("2");
	public static final Code CODE_REJECT_OVERRIDE_CONTINUE_FROM_2003_MT = new Code("3");
	public static final Code CODE_REJECT_OVERRIDE_TO_ELIGIBLE = new Code("4");
	public static final Code CODE_FORCE_REJECT_AO = new Code("5");
	public static final Code CODE_FORCE_REJECT_IVD_CONVERSION = new Code("6");
	public static final Code CODE_FORCE_REJECT_COMBAT_IN_ERROR = new Code("7");
	public static final Code CODE_FORCE_REJECT_MT_EDITED_BY_SITE = new Code("8");
	public static final Code CODE_FORCE_REJECT_HARDSHIP_NOT_IN_GOOD_FAITH = new Code("9");
	public static final Code CODE_FORCE_REJECT_CANCEL_DECLINE_REMOVE = new Code("10");
	public static final Code CODE_FORCE_REJECT_TO_ELIGIBLE = new Code("11");
	public static final Code CODE_REJECT_OVERRIDE_SHAD = new Code("12");
	public static final Code CODE_FORCE_REJECT_MEDICAID_TO_NO = new Code("13");
		
	public EnrollmentOverrideReason() {
		super();
	}
	
    public static class Code extends AbstractCode
    {
        /**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 6053555705306461140L;

		private Code(String code)
        {
            super(code);
        }

        public static Code getByCode(String code)
        {
            return (Code)getCode(Code.class, code);
        }
    }

}

